<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Changelog - FOCUS Chat - Integrando Soluções</title>
    <meta name="description" content="">



    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@200;400&display=swap" rel="stylesheet">

    <link rel="icon" type="image/png"
        href="https://fileschat.sfo2.digitaloceanspaces.com/public/whitelabels/focuschat/favicon.png" />
    <link rel="stylesheet" href="https://help.focuschat.com.br/themes/web/assets/style.css" />

    <style>
        a,
        .nav-link.w--current:active .changelog-title.color-accent,
        .footer-link:hover,
        .question-footer:hover,
        .search-title,
        .contact-details:hover,
        .dropdown-link:hover,
        .date-question,
        .date-changelog,
        .typography-size,
        .typography-size.h1,
        .nav-link-block.w--current,
        .nav-link-block.w--current:hover,
        .secondary-button,
        .mega-menu-link:hover,
        .category-title-v1,
        .category-title-v2,
        ._404-title,
        .button-white,
        .button-white:hover,
        .author-position,
        .changelog-title.color-accent,
        .text-primary {
            color: #354fe7 !important;
        }

        .hero,
        .hero.bg-primary-1,
        .bg-primary-1,
        .primary-button,
        .hero-changelog,
        .color-block.accent,
        .hero-v3.bg-primary-1,
        .licenses-hero,
        .hero-authors,
        .mobile-menu,
        .color-block.accent,
        .secondary-button-header:hover,
        .img-brand,
        .active-b,
        .pagination-button:hover {
            background-color: #354fe7 !important;
        }

        .secondary-button-header:hover,
        .pagination-button:hover,
        .active-b {
            color: white !important;
        }

        .nav-link-block.w--current,
        .nav-link-block.w--current:hover,
        .input:hover,
        .input:focus,
        .textarea:hover,
        .textarea:focus {
            border-color: #354fe7 !important;
        }

        .bg-primary-1 {
            background: #354fe7 !important;
        }

        .navbar-container .nav-menu .nav-link {
            color: white !important;
        }

        .navbar-container .nav-menu .nav-link:hover {
            color: white !important;
        }

        .navbar-container .secondary-button-header:hover {
            transform: translateY(-4px);
            background: white !important;
            color: #354fe7 !important;
            box-shadow: 0px 15px 20px rgba(46, 229, 157, 0.4);
        }

        .navbar {
            background-color: #354fe7 !important;
        }

        .rich-text-block img {
            background-color: rgba(53, 79, 231, 0.05) !important;
        }
    </style>
</head>

<body>
    <div class="ajax_load">
        <div class="ajax_load_box">
            <div class="ajax_load_box_circle"></div>
            <p class="ajax_load_box_title">Aguarde, carregando...</p>
        </div>
    </div>

    <!--CONTENT-->
    <main class="page-wrapper">

        <div class="page-wrapper">
            <div class="hero-changelog bg-primary-1 wf-section">
                <div class="container-800px">
                    <div class="text-center">
                        <h1 class="color-white">Novidades</h1>
                        <p class="paragraph-large color-white">Descubra novos recursos, correções de bugs e versões de
                            atualização</p>
                    </div>
                </div>
            </div>
            <div class="changelog-section wf-section">
                <div class="container-800px">
                    <div class="w-dyn-list">
                        <div role="list" class="collection-grid w-dyn-items">
                            <div role="listitem" class="w-dyn-item">
                                <div class="changelog-card w-inline-block">
                                    <p>✨ Novo Recurso - Roleta de Distribuição de Atendimentos: Assista o vídeo, <a href="https://www.youtube.com/watch?v=XWJlGpqsoGs" target="_blank">clique aqui</a></p>
                                    <p>✨ Novo Recurso na FOCUS Chat + SGP: Assista o vídeo, <a href="https://www.youtube.com/watch?v=9d1qUtRZ9NM" target="_blank">clique aqui</a></p>
                                    <p>✨ Incluído função de importar contatos via lista CSV.</p>
                                    <p>✨ Incluído função de agendamento de mensagens.</p>
                                    <p>✨ Incluído função de deletar contatos.</p>
                                    <p>✨ Incluído função de exportar contatos.</p>
                                    <div class="publicado" style="text-align: right; font-size: 12px;">
                                        <i>Atualização dia 16/06 - Em: 16/06/2023 07:12:09</i>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"
            integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    </main>

    <script src="https://help.focuschat.com.br/themes/web/assets/scripts.js"></script>

</body>

</html>